#include "RadiusClt1.h"
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#ifdef MT_RELEASE
#pragma comment(lib, "Agent_vc8_lib_MT.lib")
#else
#ifdef MD_RELEASE
#pragma comment(lib, "Agent_vc8_lib_MD.lib")
#endif
#endif

int main(int argc, char *argv[])
{
    if (argc < 5)
    {
        printf("Usage:uniotpdemo username OTP[PIN] host secret port timeout");
        return -1;
    }
    int nport = 1812, ntmout = 3;
    if (argc > 5)
    {
       nport = atoi(argv[5]);
    }
    if(argc > 6)
    {
       ntmout = atoi(argv[6]);
    }
    RadiusClt radclt;
    int nchalleng, nret, bvalidrp;
    char szbuf[256+1] = {0};
    radclt.initrad(argv[3], argv[4], strlen(argv[4]));
    radclt.parase(argv[1], strlen(argv[1]), argv[2], strlen(argv[2]));
    nret = radclt.auth(nchalleng, bvalidrp, szbuf, 256);
    if (RD_ERROR_SUCCESS == nret)
    {
        printf("Authentication successfully!\n");
    }
    else
    {
        if (RD_ERROR_CHALLENGENEED == nret && bvalidrp)
        {
            printf("Challenge need!Challenge code:%d\n", nchalleng);
        }
        else
        {
            printf("Authentication failed!Error Code:#%d\n", nret);
        }
    }
    return 0;
}
